#ifndef lint
static char rcsid [] = "@(#$Id: wmmain.cpp,v 1.3 2003/02/05 08:24:30 dockes Exp $  (C) 2002 Jean-Francois Dockes";
#endif

// A main file / driver for the writemime module. Unix only

#include <stdio.h>
#include <memory.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#include "writemime.h"

using namespace WriteMime;
using namespace std;

// Start editor on temporary message text file
char *edittext(const char *filename) 
{
  char *cp;
  FILE *fp = fopen(filename, "w");
  if (fp == 0) {
	fprintf(stderr, "error creating temp file\n");
	return 0;
  }
  const char *inittext=
	"Remove this line and insert the message text. No edit->cancel\n";
  fputs(inittext, fp);
  fclose(fp);
  char *ep = getenv("EDITOR");
  if (ep == 0)
	ep = "vi";
  string cmd = ep;
  cmd += " ";
  cmd += filename;
  if (system(cmd.c_str())) {
	fprintf(stderr, "Error while executing the edition command\n");
	exit(1);
  }
  int size;
  cp = readFile(filename, &size);
  if (cp && !strcmp(cp, inittext)) {
	free(cp);
	return 0;
  }
  return cp;
}

Entity::type str2type(const char* stp)
{
  if (!strcasecmp(stp, "text")) {
	return Entity::TEXT;
  } else if (!strcasecmp(stp, "image")) {
	return Entity::IMAGE;
  } else if (!strcasecmp(stp, "audio")) {
	return Entity::AUDIO;
  } else if (!strcasecmp(stp, "video")) {
	return Entity::VIDEO;
  } else if (!strcasecmp(stp, "application")) {
	return Entity::APPLICATION;
  } else {
	fprintf(stderr, 
			"Allowed content types: text, image, audio, video, application\n");
	exit(1);
  }
}

const char us_string[] = 
"Usage: writemime <-e|-m textfile> -s subject\n"
"             [-T type] [-z subtype] [-a att1 tp1 -a att2 tp2 ...] \n"
"             [-t to1 -t to2 ...] [-c cc1 -c ...] [-b bcc1 ...] \n"
"             <-S|outfile>\n"
"-e: start an editor ($EDITOR, default vi) to create a text part, or:\n"
"-m textfile: the text message part in file <textfile>\n"
"-s subject : set subject (mandatory)\n"
" -T type, -Z subtype: set the current content type and subtype. You can add\n"
"             T and Z options between attachments to set the current value.\n"
"             The type must be one of text, image, video, audio, application\n"
"-a att1:   attach file att1 with the current content type and subtype.\n"
"-t ,-c,-b  : add recipients to the to, cc, bcc lists. Recipients may be\n"
"             like \"Fullname <mailaddress>\"\n"
#ifdef WITH_SENDMAIL
"-S         : execute sendmail to send the message. Else the outfile \n"
"             parameter must be present.\n"
#endif /* WITH_SENDMAIL */
"outfile    : write the message there.\n"
;

void Usage(FILE *fp = stderr) 
{
  fprintf(fp, "%s", us_string);
  exit(1);
}
const char *thisprog;
int     op_flags;
#define OPT_e 	0x1
#define OPT_m 	0x2
#define OPT_a	0x4
#define OPT_t	0x8
#define OPT_c	0x8
#define OPT_b   0x10
#define OPT_S   0x20
#define OPT_s   0x40
#define OPT_T   0x80
#define OPT_Z   0x100

int main(int argc, char **argv)
{
  list<const char *>to, cc, bcc, attachfiles, attachsubtypes;
  list<Entity::type> attachtypes;
  char *textfile = 0;
  const char *outfile = 0;
  const char *subject = 0;
  Entity::type curtype = Entity::APPLICATION;
  const char *cursubtype = "octet-stream";

  thisprog = argv[0];
  argc--; argv++;
    
  while (argc > 0 && **argv == '-') {
    (*argv)++;
    if (!(**argv))
      Usage();
    while (**argv)
      switch (*(*argv)++) {
	  case 'h': Usage(stdout);break;
      case 'e':	op_flags |= OPT_e;break;
      case 'm':
		op_flags |= OPT_m;
		if (argc < 2)  Usage();
		textfile= *(++argv);argc--;	
		goto b1;
      case 's':
		op_flags |= OPT_s;
		if (argc < 2)  Usage();
		subject = *(++argv);argc--;
		goto b1;
      case 'a':
		op_flags |= OPT_a;
		if (argc < 2)  Usage();
		attachfiles.push_back(*(++argv));argc--;
		attachtypes.push_back(curtype);
		attachsubtypes.push_back(cursubtype);
		goto b1;
      case 't':
		op_flags |= OPT_t;
		if (argc < 2)  Usage();
		to.push_back(*(++argv));argc--;	
		goto b1;
      case 'c':
		op_flags |= OPT_t;
		if (argc < 2)  Usage();
		cc.push_back(*(++argv));argc--;	
		goto b1;
      case 'b':
		op_flags |= OPT_t;
		if (argc < 2)  Usage();
		bcc.push_back(*(++argv));argc--;
		goto b1;
      case 'T':
		op_flags |= OPT_T;
		if (argc < 2)  Usage();
		curtype = str2type(*(++argv));argc--;
		goto b1;
      case 'Z':
		op_flags |= OPT_Z;
		if (argc < 2)  Usage();
		cursubtype = *(++argv);argc--;
		goto b1;
      case 'S':	op_flags |= OPT_S;break;

      default: Usage();break;
      }
  b1: argc--; argv++;
  }
  // Need -S or outputfile
  if (((op_flags&OPT_S) && argc != 0) || (!(op_flags&OPT_S) && argc != 1))  {
    Usage();
  }
  if (argc == 1) {
	outfile = *argv++;
	argc--;
  }
  if (subject == 0) {
	fprintf(stderr, "Need to set subject with -s\n");
	exit(1);
  }
  if ((op_flags & (OPT_e|OPT_m)) == 0) {
	fprintf(stderr, "Need text part (-e or -m)\n");
	exit(1);
  }
  if (to.empty() && cc.empty() && bcc.empty()) {
	fprintf(stderr, "Need at least one recipient\n");
	exit(1);
  }


  CompositeMessage *msg = new CompositeMessage(Entity::MULTIPART, "mixed");
  msg->setSubject(subject);

  list<const char *>::iterator it;
  for (it = to.begin();it != to.end(); it++) {
	const char *cp = *it;
	if (msg->parseAddRecipients(cp, Message::TO) < 0) {
	  fprintf(stderr, "Bad recipient: %s\n", cp);
	  exit(1);
	}
  }
  for (it = cc.begin();it != cc.end(); it++) {
	const char *cp = *it;
	if (msg->parseAddRecipients(cp, Message::CC) < 0) {
	  fprintf(stderr, "Bad recipient: %s\n", cp);
	  exit(1);
	}
  }
  for (it = bcc.begin();it != bcc.end(); it++) {
	const char *cp = *it;
	if (msg->parseAddRecipients(cp, Message::BCC) < 0) {
	  fprintf(stderr, "Bad recipient: %s\n", cp);
	  exit(1);
	}
  }

  if (op_flags & OPT_e) {
	textfile = strdup("/tmp/writemimeXXXX");
	textfile = mktemp(textfile);
	if (edittext(textfile) == 0) {
	  unlink(textfile);
	  fprintf(stderr, "Cancelled\n");
	  exit(1);
	}
  }
  DiscreteEntity *txt = new DiscreteEntity;
  int size;
  char *cp = readFile(textfile, &size);
  txt->setBody(cp, size, Entity::TEXT);
  msg->addPart(txt);
  if (op_flags & OPT_e)
	unlink(textfile);

  list<Entity::type>::iterator it1;
  list<const char *>::iterator it2;
  for (it=attachfiles.begin(),
		 it1=attachtypes.begin(),it2=attachsubtypes.begin();
	   it != attachfiles.end(); it++, it1++, it2++) {
	const char *filename = *it;
	DiscreteEntity *attach = new DiscreteEntity;
	attach->setBodyAttach(filename, *it1, *it2);
	msg->addPart(attach);
  }
  Recipient from("Address", "Full Name");
  msg->setFrom(from);

  if (op_flags & OPT_S) {
	if (sendmail(msg) < 0) {
	  fprintf(stderr, "Sendmail failed: %s\n", msg->geterror());
	  exit(1);
	}
	exit(0);
  } else {
	FILE *fp = fopen(outfile, "wb");
	if (fp == 0) {
	  fprintf(stderr, "Cant open %s for writing\n", outfile);
	  exit(1);
	}
	const char *msgcp = msg->format();
	if (msgcp == 0) {
	  fprintf(stderr, "Error: %s\n", msg->geterror());
	  exit(1);
	}
	if (fputs(msgcp, fp) || fclose(fp)) {
	  fprintf(stderr, "Error writing to output file\n");
	  exit(1);
	}
  }
  exit(0);
}
